## 3c: Same housing entry price across all income groups
## All cohorts in the same income quintile enter property market with same housing entry price as top income quintile in the base scenario.


# Prelims -----------------------------------------------------------------

gc()


# Read in base housing params ---------------------------------------------

## starting cohort pathways (from step 3)
starting_cohorts_pathways <- qread(starting_cohorts_pathways_file)



# Adjust for scenario -----------------------------------------------------

new_housing_value_adj <- starting_cohorts_pathways %>%
  distinct(year, total_inc_qtile, new_housing_val_param) %>% 
  filter(total_inc_qtile==5) %>% 
  select(year, new_housing_val_param_adj = new_housing_val_param)


# Put into new version of starting_cohorts, convert to year list and save --------

starting_cohorts_pathways_adj <- starting_cohorts_pathways %>% 
  left_join(new_housing_value_adj) %>% 
  ## replace values
  select( -new_housing_val_param, new_housing_val_param = new_housing_val_param_adj )



## split into list by year - save for use in model running
year_list_0 <- starting_cohorts_pathways_adj %>% 
  split(., .$year) 

qsave(year_list_0, "./Output data/year_list_0_same_housing_entry_price.qs")
